//
//  MCTimeZoneProxy.h
//  MCFoundation
//
//  Created by Brent Gulanowski on 18/05/07.
//  Copyright 2007 Marketcircle, Inc. All rights reserved.
//
//  Description


#import <Foundation/Foundation.h>


extern NSString *ACTIVE_TIMEZONES_CHANGED;


@interface MCTimeZoneProxy : NSObject {

	NSString *cityName;
	NSTimeZone *timeZone;
	BOOL isActive;
}

+(NSDate *)dateForOffset;
+(void)setDateForOffset:(NSDate *)aDate;

+(NSArray *)cityNames;
+(NSArray *)cityTimeZoneNames;
+(NSArray *)basicCityNames;

+(NSString *)countryForCityName:(NSString *)aName;
+(NSArray *)citiesNearbyCity:(NSString *)aName;
+(NSArray *)citiesForTimeZone:(NSTimeZone *)aTimeZone;


+(NSArray *)cityTimeZones;

// the following returns a pre-existing object from the cityTimeZones array, if a match is found for city name, or nil
+(MCTimeZoneProxy *)timeZoneForCity:(NSString *)aName;
// the following returns a pre-existing object from the cityTimeZones array, if a match is found for time zone name, or nil;
// multiple cities can share the same time zone name, but which city returned is indeterminate (though it's probably the first one, alphabetically)
+(MCTimeZoneProxy *)timeZoneWithName:(NSString *)aName;
// +defaultTimeZone will never return nil, although it will try to call +timeZoneWithName: first
+(MCTimeZoneProxy *)defaultTimeZone;
// +timeZoneWithAbbreviation: is not really useful -- don't use it; it can return nil
+(MCTimeZoneProxy *)timeZoneWithAbbreviation:(NSString *)anAbbreviation;

+(NSArray *)timeZonesForCityNames:(NSArray *)names;
+(NSArray *)basicCityTimeZones;


-(int)secondsFromGMT;
-(NSString *)abbreviation;
-(BOOL)isDaylightSavingTime;
-(NSArray *)cityNames;

-(NSTimeZone *)timeZone;
-(NSString *)cityName;
-(NSString *)countryName;
-(NSString *)prettyName;

-(BOOL)isEqualToTimeZone:(MCTimeZoneProxy *)aTimeZone;

-(void)setIsActive:(BOOL)flag;
-(BOOL)isActive;

@end
